package fccsc.manager;

import java.util.Properties;


public final class MessageProperties
{
	public String  process    = "";     // VERIFY
	public String  object     = "";     // fccsc.manager.data.edit.Verify
	public boolean unitOfWork = false;  // true or false


    public
	MessageProperties( String p_process, Properties p_prop )
    {
		this.process = p_process;
		this.object  = p_prop.getProperty( "message.object"     );
		String uow   = p_prop.getProperty( "message.unitofwork" );

		if ( this.process == null ) { this.process = "";      }
		if ( this.object  == null ) { this.object  = "";      }
		if (      uow     == null ) {      uow     = "false"; }

		this.unitOfWork = new Boolean( uow ).booleanValue();
    }

	public String  getProcess()    { return process;    }
	public String  getObject()     { return object;     }
	public boolean getUnitOfWork() { return unitOfWork; }


	public String
	toString()
	{
		StringBuffer buffer = new StringBuffer();

		buffer.append( "\nMessageProperties ..." );
		buffer.append( "\n  process      [" + this.getProcess()    + "]" );
		buffer.append( "\n  object       [" + this.getObject()     + "]" );
		buffer.append( "\n  unit of work [" + this.getUnitOfWork() + "]" );

		return buffer.toString();
	}
}