package fccsc.manager;

/**
 * PBSC History
 * ************
 * PBSC palermor IR84565 05/19/2015 Update to log4j2.
 */

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


public final class MessageSender
{
    private static Logger logger = LogManager.getLogger( MessageSender.class );  // PBSC palermor IR84565

	private String       host         = "";
	private int          port         = 0;
	private byte []      dataSent     = {};
	private StringBuffer dataReceived = new StringBuffer();


//	public static void
//	main( String [] args )
//	{
//		//String studentId  = "000000003";
//		//String studentPin = "1257";
//		String studentId  = "100000006";
//		String studentPin = "0969";
//
//		String process    = "TRANSCRIPT"; //"COURSELIST"; //"VERIFY";
//		String ipAddress  = "";
//		String ipPort     = "05200";
//
//		try
//		{
//			ipAddress  = InetAddress.getLocalHost().getHostAddress();
//			ipAddress  = StringTools.padRight( ipAddress,  15, ' ' );
//
//			process    = StringTools.padRight( process,    10, ' ' );
//			studentId  = StringTools.padRight( studentId,  12, ' ' );
//			studentPin = StringTools.padRight( studentPin, 15, ' ' );
//		}
//		catch (UnknownHostException ex) { ex.printStackTrace(); }
//
//
//		String data = "" +
//		"000736TCP FEDI00FLACENTSERV0008887000001010                 " +
//		"        000001REQUEST Y\n" +
//		"        000010PROCESS " + process + "\n" +
//		"        000016STATEKEYT0001274M0000006\n" +
//		"        000015IPADDRES" + ipAddress + "\n" +
//		"        000005PORTNUMB" + ipPort    + "\n" +
//		"        000050RETNDATAWA00,                           SWWP0F00P0001282  \n" +
//		"        000030HTMLKEY                               \n" +
//		"        000012STUID   " + studentId  + "\n" +
//		"        000015PIN/PW  " + studentPin + "\n" +
//		"        000001WAIT    N\n" +
//		"        000005RETNCODE00000\n" +
//		"        000240RETNMESS                                                                                                                                                                                                                                                \n";
//
//
//
//		MessageSender sender = new MessageSender( "localhost", 5100 );
//		sender.send( data );
//
//		System.out.println( "[" + new java.util.Date().toString() + "]" );
//		System.out.println( "Data received ...["   + sender.getDataReceived() + "]" );
//		System.out.println( "Data sent .......[\n" + sender.getDataSent()     + "]" );
//		System.out.println( "* * * * * * * * * * * * * * * * * * * * * * * * * * *\n" );
//	}


	public
	MessageSender( String p_host, int p_port )
	{
		this.host = p_host.trim();
		this.port = p_port;
	}


	public void
	send( String p_data ) throws Exception
	{
		send( p_data.getBytes() );
	}


	public void
	send( byte [] p_data ) throws Exception
	{
		this.dataSent = p_data;

		Socket         socket = null;
		InputStream    in     = null;
		OutputStream   out    = null;
		BufferedReader bin    = null;
		BufferedWriter bout   = null;

		try
		{
			if ( logger.isDebugEnabled() )
			{
				logger.debug( "Sending to    [{}:{}]", this.host, this.port );  // PBSC palermor IR84565
				logger.debug( "Data sent     [{}]", this.dataSent.length );  // PBSC palermor IR84565
			}

			socket = new Socket( this.host, this.port );
			in     = socket.getInputStream();
			out    = socket.getOutputStream();
		    bin    = new BufferedReader( new InputStreamReader( in ) );
//			bout   = new BufferedWriter( new OutputStreamWriter( out ) );

//			bout.write( (String) this.dataSent );
//			bout.flush();
			out.write( this.dataSent );
			out.flush();
			socket.shutdownOutput();

			String line = "";
			while ( (line = bin.readLine()) != null )
			{
				this.dataReceived.append( line );
			}

			if ( logger.isDebugEnabled() )
			{
				logger.debug( "Data received [{} / {}]", this.dataReceived.length(), this.dataReceived );  // PBSC palermor IR84565
			}
		}
		catch (Exception e)
		{
			logger.fatal( "Communication [{}]", e.getMessage(), e );  // PBSC palermor IR84565
			throw e;
		}
		finally
		{
		    try
			{
				if ( in     != null ) { in.close(); }
	    		if ( out    != null ) { out.close(); }
		    	if ( bin    != null ) { bin.close(); }
			    if ( bout   != null ) { bout.close(); }
				if ( socket != null ) { socket.close(); }
			}
			catch (Exception e2)
			{
				logger.fatal( e2.getMessage(), e2 );
				throw e2;
			}
		}
	}


	public String getDataSent()     { return new String( this.dataSent );  }
	public String getDataReceived() { return this.dataReceived.toString(); }
}
