package fccsc.manager.apps.tester;

import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Observable;
import java.util.Observer;

import fccsc.manager.crypto.CryptoData;
import fccsc.manager.crypto.MessageCryptography;


public final class DataListener
	extends Observable
	implements Runnable
{
	private boolean      listening = false;
	private ServerSocket server    = null;
	private Socket       client    = null;


    public
	DataListener( int p_sockPort, int p_sockBackLog, Observer p_observer )
	{
		try
		{
			this.server    = new ServerSocket( p_sockPort, p_sockBackLog );
			this.listening = true;
			this.addObserver( p_observer );

			///////////////////////////////////////////////////////////////
		    // start listening
			new Thread( this ).start();
		}
		catch (Exception e)
		{
			listening = false;
			e.printStackTrace();
		}
	}

	public void
	run()
	{
		try
		{
			//DataThread threado = null;

			while ( (listening) && (server != null) )
			{
				client  = server.accept();
				//threado = new DataThread( (Socket) client );
				new DataThread( client );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( client != null ) { client.close(); }
				if ( server != null ) { server.close(); }
			}
			catch (Exception e2)
			{
				e2.printStackTrace();
			}
			listening = false;
		}
	}


	public boolean isListening() { return listening; }
	public void    setListening( boolean p_listen )
	{
	    this.listening = p_listen;

		try
		{
			if ( ! listening )
		    {
				this.server.close();
		    }
		}
		catch (Exception e) { e.printStackTrace(); }
	}


	protected final class DataThread
		extends Thread
	{
		private Socket      socket    = null;
		private InputStream stream_in = null;
		private byte []     bytesIn   = new byte[6];
		private int c;
		private int counter = 0;


		public
		DataThread( Socket p_socket )
		{
			this.socket = p_socket;
			this.start();
		}

		public void
		run()
		{
			try
			{
				if ( socket != null )
				{
					// create our reading from and writing to streams
					stream_in = this.socket.getInputStream();

					while ( (c = stream_in.read() ) != -1 )
					{
						counter++;

						bytesIn[ counter - 1 ] = (byte) c;

						if ( counter == 6 )
						{
							//System.out.println( "Storing buffer size" );
							String temp  = new String( bytesIn );
						    int    iSize = Integer.parseInt( temp.substring( 0, 6 ) );

							// now that we know how big the message we are to receive
							// reset the size of the array and copy the contents of the
							// first 6 bytes we already have read
							//
							byte [] arrTemp = bytesIn;
							bytesIn = new byte[ iSize ];

							for (int i = 0; i < 6; i++) { bytesIn[i] = arrTemp[i]; }
						}
					}
				}
			}
			catch ( Exception e)
			{
				String msg = e.getMessage();
				int    len = msg.length();
				bytesIn = new byte[ len ];

				for (int i = 0; i < len; i++)
				{ bytesIn[i] = (byte) msg.charAt( i ); }
			}
			finally
			{
				try
				{
					if ( stream_in  != null ) { stream_in.close();  }
					if ( socket     != null ) { socket.close();     }
				}
				catch (Exception e2)
				{
					String msg = e2.getMessage();
					int    len = msg.length();
					bytesIn = new byte[ len ];

					for (int i = 0; i < len; i++)
					{ bytesIn[i] = (byte) msg.charAt( i ); }
				}
			}

		    CryptoData crypdata = null;

		    // check for encrypted data
			//
			if ( (char) bytesIn[15] == '3' )
			{
				String id = MainPanel.getMessageId( this.bytesIn );

				crypdata = MainPanel.hashSessionKeys.get( id.trim() );

				byte [] arrData = MessageCryptography.decryptWithSessionKey(
														    this.bytesIn,
															crypdata.getSessionKey() );
				crypdata = new CryptoData( arrData, crypdata.getSessionKey() );

				MainPanel.hashSessionKeys.remove( id );
			}
			else
			{
				crypdata = new CryptoData( bytesIn, null );
			}

			DataListener.this.setChanged();
			DataListener.this.notifyObservers( crypdata );
		}
	}
}