package fccsc.manager.apps.tester;

/**
 * PBSC History
 * ************
 * PBSC palermor 167972 10/02/2013 Add method for loading external XML files for testing.
 * PBSC palermor IR127093 07/30/2015 Change FACTS/FLVC to FloridaShines.
 * PBSC palermor IR158889 01/07/2016 Add EDI file testing to MessageTester. Combine prior XML
 *                                   file options to 1 since the process name is irrelevant for 
 *                                   both EDI and XML files.
 */

import intarsys.util.PropertyManager;
import intarsys.util.StringTools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

import fccsc.manager.MessageSender;
import fccsc.manager.crypto.CryptoData;
import fccsc.manager.crypto.MessageCryptography;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.edi.StandardDataBlock;


public class MainPanel
	extends JPanel
	implements Observer
{
	private static final long serialVersionUID = 1L;

	private final String DATE_FORMAT = "HH:mm:ss:SSS";

	private final String [][] arrProcesses = {  { "EDI - Verify",             "VERIFY"     },   // 0
												{ "EDI - Course List",        "COURSELIST" },   // 1
												{ "EDI - Transcript",         "TRANSCRIPT" },   // 2
												{ "EDI - Degree Audit",       "GRADAUDIT"  },   // 3
												{ "EDI - Local Shop",         "LOCALSHOP"  },   // 4
												{ "EDI - FloridaShines Shop", "FACTSSHOP"  },   // 5  // PBSC palermor IR127093
												{ "EDI - Remote Shop",        "REMOTESHOP" },   // 6
												{ "XML - Admission",          "ADMISSION"  },   // 7
												{ "XML - 22 Advise",          "22ADVISE"   },   // 8
												{ "EDI File",                 ""           },   // 9  // PBSC palermor IR158889
												{ "XML File",                 ""           } }; // 10  // PBSC palermor IR158889
	private String callbackIpAddress = "";
	private String callbackIpPort    = "";
	private String sendtoIpAddress   = "";
	private int    sendtoIpPort      = 0;
	private int    threadsCount      = 1;
	private int    encryptionIndex   = 0;
	private String data              = "";

	public static Hashtable<String, CryptoData> hashSessionKeys = new Hashtable<String, CryptoData>( 2 );


    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    //private Border border1;
    private Border border2;
    //private Border border3;
    private TitledBorder titledBorder2;
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea areaSent = new JTextArea();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTextArea areaRecieved = new JTextArea();
    private JPanel jPanel3 = new JPanel();
    private JLabel labelStatus = new JLabel();
    private Border border5;
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JTextField fieldPinPassword = new JTextField();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JTextField fieldStudentId = new JTextField();
    private JComboBox<String> comboProcesses = new JComboBox<String>();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    //private Border border4;
    //private TitledBorder titledBorder1;
    private JPanel jPanel5 = new JPanel();
    private JTextField fieldIpAddress = new JTextField();
    private JTextField fieldIpPort = new JTextField();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private JLabel jLabel6 = new JLabel();
    private JLabel jLabel7 = new JLabel();
    private Border border6;
    private TitledBorder titledBorder3;
    private JLabel jLabel4 = new JLabel();
    private JComboBox<String> comboThreads = new JComboBox<String>();
    private JButton buttonSend = new JButton();
    private JLabel jLabel5 = new JLabel();
    private JComboBox<String> comboEncryption = new JComboBox<String>();
    
    // PBSC palermor 167972, IR158889 START
    // EDI
    private JLabel ediFileChooserLabel = new JLabel();
    private JTextField ediFileChooserField = new JTextField();
    private JButton ediFileChooserButton = new JButton();
    private JFileChooser ediFileChooser = new JFileChooser();

    // XML
    private JLabel xmlFileChooserLabel = new JLabel();
    private JTextField xmlFileChooserField = new JTextField();
    private JButton xmlFileChooserButton = new JButton();
    private JFileChooser xmlFileChooser = new JFileChooser();
    
    // Common file setting
    private JLabel fileChooserHeaderComboLabel = new JLabel();
    private JComboBox<String> fileChooserHeaderCombo = new JComboBox<String>();
    // PBSC palermor 167972, IR158889 END

    public MainPanel()
    {
        try
        {
            jbInit();

		    initCryptography();

			startListener();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception
    {
        //border1 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        border2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Message Information");
        //border3 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Message Sent / Received");
        border5 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        //border4 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        //titledBorder1 = new TitledBorder(border4,"Destination Information");
        border6 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        titledBorder3 = new TitledBorder(border6,"Destination Information");
        jPanel2.setLayout(gridBagLayout1);
        this.setLayout(borderLayout1);
        jPanel2.setBorder(titledBorder2);
        jScrollPane1.getViewport().setBackground(Color.black);
        areaSent.setText("Ready to Send . . .");
        areaSent.setEditable(false);
        areaSent.setForeground(Color.green);
        areaSent.setFont(new java.awt.Font("Monospaced", 1, 12));
        areaSent.setBackground(Color.black);
        areaRecieved.setBackground(Color.green);
        areaRecieved.setFont(new java.awt.Font("Monospaced", 1, 12));
        areaRecieved.setEditable(false);
        areaRecieved.setText("Ready to Receive . . .");
        jSplitPane1.setLastDividerLocation(300);
        jSplitPane1.setOneTouchExpandable(true);
        labelStatus.setForeground(Color.black);
        labelStatus.setText("Ready ...");
        jPanel3.setLayout(gridBagLayout3);
        jPanel3.setBorder(border5);
        jPanel1.setLayout(gridBagLayout2);
        jPanel1.setBorder(border2);
        fieldPinPassword.setFont(new java.awt.Font("Dialog", 1, 12));
        fieldPinPassword.setForeground(Color.blue);
        fieldPinPassword.setText("0969");
        fieldPinPassword.setColumns(9);
        fieldStudentId.setFont(new java.awt.Font("Dialog", 1, 12));
        fieldStudentId.setForeground(Color.blue);
        fieldStudentId.setText("000000006");
        fieldStudentId.setColumns(9);
        jLabel3.setText("Message");
        jLabel2.setText("Student Id");
        jLabel1.setText("Pin / Password");
        
        // PBSC palermor 167972, IR158889 START
        // EDI
        ediFileChooserLabel.setText("EDI File");
        ediFileChooserField.setFont(new java.awt.Font("Dialog", 1, 12));
        ediFileChooserField.setForeground(Color.blue);
        ediFileChooserField.setColumns(14);
        ediFileChooserButton.setText("Browse...");
        ediFileChooser.setAcceptAllFileFilterUsed(false);
		ediFileChooser.setFileFilter(new FileFilter() {

			@Override
			public String getDescription() {
				return "EDI Files";
			}

			@Override
			public boolean accept(File file) {
				if (file.isDirectory()) {
					return true;
				}

				String fileName = file.getName();
				int dot = fileName.lastIndexOf(".");

				if (dot > -1) {
					String extension = fileName.substring(fileName.lastIndexOf("."));

					if (extension.equalsIgnoreCase(".edi")) {
						return true;
					}
				}

				return false;
			}
		});
        
		ediFileChooserButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				int returnVal = ediFileChooser.showOpenDialog(null);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					File file = ediFileChooser.getSelectedFile();
					ediFileChooserField.setText(file.getAbsolutePath());
				}
			}
		});

		ediFileChooserLabel.setEnabled(false);
        ediFileChooserField.setEnabled(false);
        ediFileChooserButton.setEnabled(false);

        // XML
        xmlFileChooserLabel.setText("XML File");
        xmlFileChooserField.setFont(new java.awt.Font("Dialog", 1, 12));
        xmlFileChooserField.setForeground(Color.blue);
        xmlFileChooserField.setColumns(14);
        xmlFileChooserButton.setText("Browse...");
        xmlFileChooser.setAcceptAllFileFilterUsed(false);
		xmlFileChooser.setFileFilter(new FileFilter() {

			@Override
			public String getDescription() {
				return "XML Files";
			}

			@Override
			public boolean accept(File file) {
				if (file.isDirectory()) {
					return true;
				}

				String fileName = file.getName();
				int dot = fileName.lastIndexOf(".");

				if (dot > -1) {
					String extension = fileName.substring(fileName.lastIndexOf("."));

					if (extension.equalsIgnoreCase(".xml")) {
						return true;
					}
				}

				return false;
			}
		});
        
		xmlFileChooserButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				int returnVal = xmlFileChooser.showOpenDialog(null);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					File file = xmlFileChooser.getSelectedFile();
					xmlFileChooserField.setText(file.getAbsolutePath());
				}
			}
		});

		fileChooserHeaderComboLabel.setText("Header in File");
		
		xmlFileChooserLabel.setEnabled(false);
        xmlFileChooserField.setEnabled(false);
        xmlFileChooserButton.setEnabled(false);
        
        fileChooserHeaderComboLabel.setEnabled(false);
        fileChooserHeaderCombo.setEnabled(false);
        fileChooserHeaderCombo.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				if (fileChooserHeaderCombo.isEnabled()) {
					int fcSelectIndex = fileChooserHeaderCombo.getSelectedIndex();
					areaSent.append("\n=====================================\n");
					if (fcSelectIndex == 0) {
						areaSent.append("A standard header will be used.");
					} else {
						int selectedIndex = comboProcesses.getSelectedIndex();
						if( selectedIndex == 9 ){
							areaSent.append("Ensure your header starts with:\n\nTCP FEDI\n\nBuffer length will be calculated \nand prepended prior to send.");
						} else if ( selectedIndex == 10 ){
							areaSent.append("Ensure your header starts with:\n\nTCP FXML\n\nBuffer length will be calculated \nand prepended prior to send.");
						}
					}
					areaSent.append("\n=====================================\n");
				}
			}
		});
        // PBSC palermor 167972, IR158889 END
        
        jPanel4.setLayout(gridBagLayout4);
        jPanel5.setLayout(gridBagLayout5);
        fieldIpAddress.setFont(new java.awt.Font("Dialog", 1, 12));
        fieldIpAddress.setForeground(Color.red);
        fieldIpAddress.setText("localhost");
        fieldIpAddress.setColumns(15);
        fieldIpPort.setFont(new java.awt.Font("Dialog", 1, 12));
        fieldIpPort.setForeground(Color.red);
        fieldIpPort.setText("5100");
        fieldIpPort.setColumns(5);
        jLabel6.setText("IP Port");
        jLabel7.setText("IP Address");
        jPanel5.setBorder(titledBorder3);
        jLabel4.setText("Threads");
        buttonSend.setText("Send");
        buttonSend.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                buttonSend_actionPerformed(e);
            }
        });
        jLabel5.setText("Encrypt");
        comboProcesses.setMaximumRowCount(12);
        comboThreads.setMaximumRowCount(12);
        this.add(jPanel2,  BorderLayout.CENTER);
        this.add(jPanel3,  BorderLayout.SOUTH);
        jPanel2.add(jSplitPane1,     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add(labelStatus,    new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel4, BorderLayout.NORTH);
        jPanel4.add(jPanel1,              new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add(comboProcesses,              new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(jLabel1,            new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(fieldPinPassword,            new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 9, 0));
        jPanel1.add(jLabel2,            new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 3, 3, 3), 0, 0));
        jPanel1.add(fieldStudentId,            new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 9, 0));
        jPanel1.add(jLabel3,               new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(buttonSend,          new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));

        // PBSC palermor 167972, IR158889 START
        // EDI
        jPanel1.add(ediFileChooserLabel,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(ediFileChooserField,    new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
                ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(ediFileChooserButton,          new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
                ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        
        // XML
        jPanel1.add(xmlFileChooserLabel,    new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(xmlFileChooserField,    new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
                ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(xmlFileChooserButton,          new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0
                ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        
        jPanel1.add(fileChooserHeaderComboLabel,       new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(fileChooserHeaderCombo,         new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
                ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));

        jPanel1.add(jLabel5,       new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
                ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel1.add(comboEncryption,         new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0
                ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
// PBSC palermor 167972, IR158889 END

        jPanel4.add(jPanel5,            new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(jLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel5.add(fieldIpAddress, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 15, 0));
        jPanel5.add(fieldIpPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 5, 0));
        jPanel5.add(jLabel6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel5.add(jLabel4,    new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jPanel5.add(comboThreads,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(3, 3, 3, 3), 0, 0));
        jSplitPane1.setDividerLocation(350);
        jScrollPane1.getViewport().add(areaSent, null);
        jScrollPane2.getViewport().add(areaRecieved, null);
		jSplitPane1.setOrientation( JSplitPane.HORIZONTAL_SPLIT );
        jSplitPane1.add(jScrollPane1, JSplitPane.LEFT);
        jSplitPane1.add(jScrollPane2, JSplitPane.RIGHT);


		// load the messages combo listing
		for ( int i = 0; i < arrProcesses.length; i++ )
		{
			comboProcesses.insertItemAt( arrProcesses[i][0], i );
		}
	    comboProcesses.setSelectedIndex( 0 );
	    
	    // PBSC palermor 167972, IR158889 START
		comboProcesses.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				int selected = comboProcesses.getSelectedIndex();

				if ( selected == 9 ) {
					ediFileChooserLabel.setEnabled(true);
					ediFileChooserField.setEnabled(true);
					ediFileChooserButton.setEnabled(true);
					fileChooserHeaderComboLabel.setEnabled(true);
					fileChooserHeaderCombo.setEnabled(true);
					fileChooserHeaderCombo.setSelectedIndex(1); // To trigger text message.
					areaSent.append("\n=====================================\n");
					areaSent.append("Don't forget to set the IPADDRESS \nand PORT in the test file to (without quotes - note any spaces): \n\n\"000015IPADDRES" + callbackIpAddress + "\"\n\"000005PORTNUMB" + callbackIpPort + "\"");
					areaSent.append("\n=====================================\n");

					xmlFileChooserLabel.setEnabled(false);
					xmlFileChooserField.setEnabled(false);
					xmlFileChooserButton.setEnabled(false);
			        fieldPinPassword.setEnabled(false);
			        fieldStudentId.setEnabled(false);
					return;
				} else if( selected == 10 ){
					xmlFileChooserLabel.setEnabled(true);
					xmlFileChooserField.setEnabled(true);
					xmlFileChooserButton.setEnabled(true);
					fileChooserHeaderComboLabel.setEnabled(true);
					fileChooserHeaderCombo.setEnabled(true);
					fileChooserHeaderCombo.setSelectedIndex(1); // To trigger text message.
					areaSent.append("\n=====================================\n");
					areaSent.append("Don't forget to set the IPADDRESS \nand PORT in the test file to: \n\n<IPADDRESS>" + callbackIpAddress.trim() + "</IPADDRESS> \n<PORT>" + Integer.parseInt( callbackIpPort ) + "</PORT>");
					areaSent.append("\n=====================================\n");

					ediFileChooserLabel.setEnabled(false);
					ediFileChooserField.setEnabled(false);
					ediFileChooserButton.setEnabled(false);
			        fieldPinPassword.setEnabled(false);
			        fieldStudentId.setEnabled(false);
					return;
				}

		        fieldPinPassword.setEnabled(true);
		        fieldStudentId.setEnabled(true);

		        ediFileChooserLabel.setEnabled(false);
				ediFileChooserField.setEnabled(false);
				ediFileChooserButton.setEnabled(false);

				xmlFileChooserLabel.setEnabled(false);
				xmlFileChooserField.setEnabled(false);
				xmlFileChooserButton.setEnabled(false);

				fileChooserHeaderComboLabel.setEnabled(false);
				fileChooserHeaderCombo.setEnabled(false);
			}
		});
		
		fileChooserHeaderCombo.insertItemAt(  "No",  0 );
		fileChooserHeaderCombo.insertItemAt( "Yes",  1 );
		fileChooserHeaderCombo.setSelectedIndex( 1 );
	    // PBSC palermor 167972, IR158889 END

		comboThreads.insertItemAt(  "1",  0 );
		comboThreads.insertItemAt(  "2",  1 );
		comboThreads.insertItemAt(  "3",  2 );
		comboThreads.insertItemAt(  "4",  3 );
		comboThreads.insertItemAt(  "5",  4 );
		comboThreads.insertItemAt( "10",  5 );
		// load the thread count combo
		for ( int i = 1; i <= 6; i++ )
		{
			comboThreads.insertItemAt( "" + (i * 25), i + 5 );
		}
		comboThreads.setSelectedIndex( 0 );


		comboEncryption.insertItemAt(  "No",  0 );
		comboEncryption.insertItemAt( "Yes",  1 );
		comboEncryption.setSelectedIndex( 0 );
    }

    void buttonSend_actionPerformed(ActionEvent e)
    {
		process();

		areaRecieved.setCursor( Cursor.getPredefinedCursor( Cursor.WAIT_CURSOR ) );
    }


	private void
	initCryptography()
	{
//		this.crypto.init();
	}


	private void
	startListener()
	{
		Properties prop      = PropertyManager.getProperty( "manager.properties" );
		this.callbackIpPort  = prop.getProperty( "tester.listener.port" );
		int listeningPort    = Integer.parseInt( callbackIpPort );
		int listeningBackLog = Integer.parseInt( prop.getProperty( "tester.listener.backlog" ) );

		new DataListener( listeningPort, listeningBackLog, this );

		try { this.callbackIpAddress = InetAddress.getLocalHost().getHostAddress(); }
		catch (UnknownHostException ex) { ex.printStackTrace(); }

		labelStatus.setText( "  Listening on ip [" + callbackIpAddress + "] and port [" + listeningPort + "] with a backlog of [" + listeningBackLog + "]." );

		this.callbackIpAddress = StringTools.padRight( this.callbackIpAddress, 15, ' ' );
		this.callbackIpPort    = StringTools.padLeft(  this.callbackIpPort,     5, '0' );

		this.fieldIpPort.setText( prop.getProperty( "manager.listener.port" ) );
	}


	private void
	process()
	{
		String studentId      = fieldStudentId.getText();
		String studentPin     = fieldPinPassword.getText();
		int    processIndex   = comboProcesses.getSelectedIndex();
		String process        = arrProcesses[ processIndex ] [1];
		String threadsValue   = (String) comboThreads.getSelectedItem();
		String enc            = "0";

		this.data = "";  // PBSC palermor 167972  Reset this.
		this.threadsCount    = Integer.parseInt( threadsValue );
		this.sendtoIpAddress = fieldIpAddress.getText();
		this.sendtoIpPort    = Integer.parseInt( fieldIpPort.getText() );
		this.encryptionIndex = comboEncryption.getSelectedIndex();

		process    = StringTools.padRight( process,    10, ' ' );
		studentId  = StringTools.padRight( studentId,  12, ' ' );
		studentPin = StringTools.padRight( studentPin, 15, ' ' );

		if ( sendtoIpAddress.trim().equalsIgnoreCase( "localhost" ) )
		{
			sendtoIpAddress = this.callbackIpAddress;
		}

		if ( encryptionIndex == 1 ) { enc = "3"; }


		// EDI message
		if ( (processIndex == 0) || // Verify
			 (processIndex == 1) || // Course List
			 (processIndex == 2) || // Transcript
			 (processIndex == 3) || // Degree Audit
			 (processIndex == 4) || // Local Shop
			 (processIndex == 5) || // FACTS Shop
			 (processIndex == 6)  ) // Remote Shop
		{
			data = "" +
			"000736TCP FEDI0" + enc + "FLACENTSERV0008887000001010                 " +
			"        000001REQUEST Y\n" +
			"        000010PROCESS " + process + "\n" +
			"        000016STATEKEYT0001274M0000006\n" +
			"        000015IPADDRES" + this.callbackIpAddress + "\n" +
			"        000005PORTNUMB" + this.callbackIpPort    + "\n" +
			"        000050RETNDATAWA00,                           SWWP0F00P0001282  \n" +
			"        000030HTMLKEY                               \n" +
			"        000012STUID   " + studentId  + "\n" +
			"        000015PIN/PW  " + studentPin + "\n" +
			"        000001WAIT    N\n" +
			"        000005RETNCODE00000\n" +
			"        000240RETNMESS                                                                                                                                                                                                                                                \n";

			if ( (processIndex == 4) || // Local Shop
				 (processIndex == 5) || // FACTS Shop
				 (processIndex == 6)  ) // Remote Shop
			{
				ControlBlock      ediCB  = new ControlBlock( data );
				StandardDataBlock ediSDB = new StandardDataBlock( data );
				StringBuffer      ediPDB = new StringBuffer();

				ediPDB.append( StringTools.padRight( "",  8, ' ' ) );
				ediPDB.append( "000010MAJOR   " );
				ediPDB.append( "10504     " );
				ediPDB.append( "\n" );
				ediPDB.append( StringTools.padRight( "",  8, ' ' ) );
				ediPDB.append( "000006CATLYEAR" );
				ediPDB.append( "200201" );
				ediPDB.append( "\n" );

				if ( (processIndex == 5) || // FACTS Shop
					 (processIndex == 6)  ) // Remote Shop
				{
					ediPDB.append( StringTools.padRight( "", 8, ' ' ) );
					ediPDB.append( "000001ASSUMEAA" );
					ediPDB.append( "Y" );
					ediPDB.append( "\n" );

					// attach the CLB (Course List Block)
					ediPDB.append( "        000100DEMOGRAF001512 1   000000006CHRISTOPHER MARK HARRIS                                     19690918NNN         \n" );
					ediPDB.append( "        000119COURSLST198808 0001512      ENC 1101        FRESHMAN COMM I          ENC 1101        0 W  003000        U S                    \n" );
					ediPDB.append( "        000119COURSLST198808 0001512      JOU 1100        MASS COMM                MMC 1100        0 W  003000        U S                    \n" );
					ediPDB.append( "        000119COURSLST198808 0001512      MGF 1103        GENERAL ED MATH I        MGF 1103        0 W  003000        U S                    \n" );
					ediPDB.append( "        000119COURSLST198808 0001512      PEL 2341        BEGINNING TENNIS         PEL 2341        0 W  001000        U S                    \n" );
					ediPDB.append( "        000119COURSLST198808 0001512      POS 2041        AMER NATIONAL GOVERN     POS 1041        0 W  003000        U S                    \n" );
				}


				int lenTotal = ediCB.getData().length() + ediSDB.getData().length() + ediPDB.length();

				ediCB.setTotalRecordSize( String.valueOf( lenTotal ) );

				data = ediCB.getData() + ediSDB.getData() + ediPDB.toString();
			}
		}

		// XML message - ADMISSION
		else if ( processIndex == 7 ) // Admissions
		{
			data = "" +
			"001308TCP FXML0" + enc + "FLACENTSERV0008887000001010                 " +
			"<?xml version='1.0'?>" +
			"<FACTS_MESSAGE Process='ADMISSION' Request='Y' Wait='N'>" +
				"<STANDARD_BLK>" +
	    			"<STATEKEY>T0001274M0000006</STATEKEY>" +
		    		"<IPADDRESS>" + this.callbackIpAddress + "</IPADDRESS>" +
			    	"<PORT>"      + this.callbackIpPort    + "</PORT>" +
				    "<RETNDATA>WA00,                           SWWP0F00P0001282  </RETNDATA>" +
					"<HTMLKEY>;2C;;2001;</HTMLKEY>" +
	    			"<STUID>"     + studentId  + "</STUID>" +
		    		"<PIN_PW>"    + studentPin + "</PIN_PW>" +
			    	"<RETNCODE>00000</RETNCODE>" +
				    "<RETNMESS></RETNMESS>" +
				"</STANDARD_BLK>" +
				"<ADMISSION_REQ FACTS_ID=''>" +
					"<HIGH_SCHOOL/>" +
					"<PREV_INST END_MON='' BEG_YR='' BEG_MON='' END_YR=''/>" +
					"<FLA_RESIDENCY/>" +
					"<NON-US_INFO/>" +
					"<ADM_TEST DAY='' MON='' YR=''>" +
						"<TEST_TYPE_CD></TEST_TYPE_CD>" +
						"<TEST_SCORE></TEST_SCORE>" +
					"</ADM_TEST>" +
					"<COURSE CredType='' CredHrs='' DAY='' MON='' CrsNbr='' YR='' CrsStatus='C'>" +
						"<INST_NAME></INST_NAME>" +
						"<COURSE_TITLE></COURSE_TITLE>" +
					"</COURSE>" +
					"<ACTIVITY END_MON='' BEG_YR='' BEG_MON='' END_YR='' OccCode=''>" +
						"<CITY></CITY>" +
						"<STATE></STATE>" +
						"<COUNTRY Code=''></COUNTRY>" +
					"</ACTIVITY>" +
					"<ALUMNI_INFO>" +
						"<NAME Relationship=''>" +
							"<LAST_NAME/>" +
							"<FIRST_NAME/>" +
							"<MIDDLE_NAME></MIDDLE_NAME>" +
							"<SUFFIX></SUFFIX>" +
						"</NAME>" +
						"<UNIVERSITY></UNIVERSITY>" +
					"</ALUMNI_INFO>" +
					"<FAMILY_INFO Relationship=''>" +
						"<HIGHEST_ED></HIGHEST_ED>" +
						"<OCCUPATION></OCCUPATION>" +
					"</FAMILY_INFO>" +
					"<OBLIGATION OblType='W'></OBLIGATION>" +
					"<EXTRACURRICULAR ActType=''></EXTRACURRICULAR>" +
				"</ADMISSION_REQ>" +
			"</FACTS_MESSAGE>";
		}

		// XML message - 22ADVISE
		else if ( processIndex == 8 ) // 22 Advise
		{
			data = "" +
			"000554TCP FXML0" + enc + "FLACENTSERV0008887000001010                 " +
			"<?xml version='1.0'?>" +
			"<FACTS_MESSAGE Process='22ADVISE' Request='Y' Wait='N'>" +
				"<STANDARD_BLK>" +
	    			"<STATEKEY>T0001274M0000006</STATEKEY>" +
		    		"<IPADDRESS>" + this.callbackIpAddress + "</IPADDRESS>" +
			    	"<PORT>"      + this.callbackIpPort    + "</PORT>" +
				    "<RETNDATA>WA00,                           SWWP0F00P0001282  </RETNDATA>" +
					"<HTMLKEY>;2C;;2001;</HTMLKEY>" +
	    			"<STUID>"     + studentId  + "</STUID>" +
		    		"<PIN_PW>"    + studentPin + "</PIN_PW>" +
			    	"<RETNCODE>00000</RETNCODE>" +
				    "<RETNMESS></RETNMESS>" +
				"</STANDARD_BLK>" +
		    	"<ADVISE22_REQ>" +
		   	    	"<MAJOR>10504</MAJOR>" +
			    	"<CATLYEAR>2001</CATLYEAR>" +
	    	    "</ADVISE22_REQ>" +
			"</FACTS_MESSAGE>";
		}
		// PBSC palermor 167972, IR158889 START
		else if( processIndex == 9 ){
			String fileName = ediFileChooserField.getText();
			
			if(fileName == null || fileName.trim().equals("")){
				areaSent.append( "\nFILE NOT SELECTED!!!!" );
				return;
			}
			
			BufferedReader br = null;
			try {
				File file = new File(fileName);

				if (!file.exists()) {
					areaSent.append("\nFILE DOES NOT EXIST!!!\n");
					areaSent.append(file.getAbsolutePath());
					return;
				}

				StringBuffer buf = new StringBuffer();
				br = new BufferedReader(new FileReader(file));
				String line;
				while ((line = br.readLine()) != null) {
					buf.append(line);

					// For some reason the code expects new line characters to exist (to meet the length) and when reading in a 
					// file I don't get the character for the new line so I need to add them.
					buf.append("\n");  
				}
				
				if (fileChooserHeaderCombo.getSelectedIndex() == 0) {
					data =  "TCP FEDI0" + enc + "FLACENTSERV0008887000001010                 ";
				}

				data += buf.toString();

				String bufLength = StringTools.padLeft(String.valueOf(data.length() + 6), 6, '0');

				data = bufLength + data;

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (Exception e) {
						// Do Nothing
					}
				}
			}
		}
		else if( processIndex == 10 ){
			String fileName = xmlFileChooserField.getText();
			
			if(fileName == null || fileName.trim().equals("")){
				areaSent.append( "\nFILE NOT SELECTED!!!!" );
				return;
			}
			
			BufferedReader br = null;
			try {
				File file = new File(fileName);

				if (!file.exists()) {
					areaSent.append("\nFILE DOES NOT EXIST!!!\n");
					areaSent.append(file.getAbsolutePath());
					return;
				}

				StringBuffer buf = new StringBuffer();
				br = new BufferedReader(new FileReader(file));
				String line;
				while ((line = br.readLine()) != null) {
					buf.append(line);
				}
				
				if (fileChooserHeaderCombo.getSelectedIndex() == 0) {
					data =  "TCP FXML0" + enc + "FLACENTSERV0008887000001010                 ";
				}

				data += buf.toString();

				String bufLength = StringTools.padLeft(String.valueOf(data.length() + 6), 6, '0');

				data = bufLength + data;

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (Exception e) {
						// Do Nothing
					}
				}
			}
		}
		// PBSC palermor 167972, IR158889 END
		
		///////////////////////////////////////////////////////////////////////////////////
		// send data
		//
		try
		{
			if ( this.threadsCount == 1 )
			{
				areaSent.setText( "[" + new SimpleDateFormat( DATE_FORMAT ).format( new Date() ) + "]\n" );
	    		areaRecieved.setText( "Waiting for data ..." );

				byte [] dataBytes = data.getBytes();

				// check for encryption usage
				//
				if ( MainPanel.this.encryptionIndex == 1 ) // Yes
				{
				    int id = 1;
				    data = setMessageId( data, id );

				    CryptoData crypdata = MessageCryptography.encrypt( data );

				    dataBytes = crypdata.getData();

				    hashSessionKeys.put( String.valueOf( id ), crypdata );
				}

				MessageSender sender = new MessageSender( sendtoIpAddress, sendtoIpPort );
				sender.send( dataBytes );

				if ( MainPanel.this.encryptionIndex == 1 )
				{
					areaSent.append( "\nENCRYPTED" );
				}
				areaSent.append( "\nData sent ....... (" + data.length() + ")" );
				areaSent.append( "\n[" + data + "]" );
				areaSent.append( "\nData received ... ["   + sender.getDataReceived() + "]" );
			}
			else
			{
				areaSent.setText(     "Sending " + this.threadsCount + " threads ... \n" );
	    		areaRecieved.setText( "Waiting for " + this.threadsCount + " threads ... \n" );

				for ( int i = 0; i < this.threadsCount; i++ )
				{
					new SenderThread( i ).start();
				}
			}
		}
		catch (Exception ex)
		{
			areaSent.setText( "EXCEPTION ...\n" );
			areaSent.append( "\n* * * * * * * * * * * * * * * * * * * * * * * * * * *" );
			areaSent.append( "\n" + ex.getMessage() );
			areaSent.append( "\n* * * * * * * * * * * * * * * * * * * * * * * * * * *" );

			areaRecieved.setText( "<--- An exception occurred !" );
		}
	}


	/*
	 * Interface Method.
	 */
	public void
	update( Observable o, Object arg )
	{
		CryptoData crypdata = (CryptoData) arg;

		if ( this.threadsCount == 1 )
		{
			areaRecieved.setText( "[" + new SimpleDateFormat( DATE_FORMAT ).format( new Date() ) + "]\n" );

			if ( crypdata.isEncrypted() )
			{
				areaRecieved.append( "\nENCRYPTED" );
			}
			areaRecieved.append( "\nData received ... (" + crypdata.getData().length + ")" );
			areaRecieved.append( "\n[" + new String( crypdata.getData() ) + "]" );
			areaRecieved.setCursor( Cursor.getDefaultCursor() );
		}
		else
		{
		    areaRecieved.append( "\nReceived ... (" + crypdata.getData().length + ") " );
		    areaRecieved.append( "[" + new SimpleDateFormat( DATE_FORMAT ).format( new Date() ) + "]" );
			if ( crypdata.isEncrypted() )
			{
				areaRecieved.append( " ENCRYPTED" );
			}
			//areaRecieved.append( "\n[" + arg + "]" );
		}
	}

    void buttonExit_actionPerformed(ActionEvent e)
    {
		System.exit( 0 );
    }


	public static String
	setMessageId( String p_data, int p_messageId )
	{
		StringBuffer buffer = new StringBuffer( p_data );

		String id = StringTools.padLeft( String.valueOf( p_messageId ), 6, ' ' );

		for ( int i = 0; i < id.length(); i++ )
		{
			buffer.setCharAt( 54 + i, id.charAt( i ) );
		}

	    return buffer.toString();
	}


	public static String
	getMessageId( byte [] p_data )
	{
		StringBuffer buffer = new StringBuffer();

		for ( int i = 0; i < 6; i++ )
		{
			buffer.append( (char) p_data[ 54 + i ] );
		}

		return buffer.toString();
	}



	class SenderThread
		extends Thread
	{
		private int id = 0;

		public
		SenderThread( int p_id )
		{
			this.id = p_id;
		}


		public void
		run()
		{
			try
			{
			    byte [] dataBytes = MainPanel.this.data.getBytes();

				if ( MainPanel.this.encryptionIndex == 1 ) // Yes
				{
				    String data = setMessageId( MainPanel.this.data, this.id );

				    CryptoData crypdata = MessageCryptography.encrypt( data );

				    dataBytes = crypdata.getData();

				    hashSessionKeys.put( String.valueOf( this.id ),crypdata);
				}

				MessageSender sender2 = new MessageSender(
												MainPanel.this.sendtoIpAddress,
												MainPanel.this.sendtoIpPort );
				sender2.send( dataBytes );

				areaSent.append( "\nSent ... [" + this.getName() + "] " );
				areaSent.append( "[" + new SimpleDateFormat( DATE_FORMAT ).format(
															new Date() ) + "]" );

				if ( MainPanel.this.encryptionIndex == 1 )
				{ areaSent.append( " ENCRYPTED" ); }
			}
			catch (Exception ex) { ex.printStackTrace(); }
		}
	}
}