package fccsc.manager.apps.tester;

/**
 * PBSC History
 * ************
 * PBSC palermor 167972 10/02/2013 Change location of property files.
 * 
 */

import fccsc.manager.crypto.MessageCryptography;
import intarsys.util.PropertyManager;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

import javax.swing.JFrame;


public class MessageTester
	extends JFrame
{
	private static final long serialVersionUID = 1L;

	private MainPanel panelMain = new MainPanel();


	public static void
	main( String [] args )
	{
		try
		{
			/////////////////////////////////////////////////////////////
			//
			// get the current directory path
			File f = new File( "." );

			///////////////////////////////////////////////////////////////
			// load the properties files
			// and fetch parameter values for this object's construction
			//
			PropertyManager.init( f.getCanonicalPath() + File.separator + "bin");//"properties" );  // PBSC palermor 167972
			PropertyManager.loadAll();

			///////////////////////////////////////////////////////////////
			// load the log4j properties
			//
			//Properties propLog4j = PropertyManager.getProperty( "log4j.properties" );    // ROCCO
			//PropertyConfigurator.configure( propLog4j );  // ROCCO

			///////////////////////////////////////////////////////////////
			// initialize our cryptography object
			//
			Properties propCrypto = PropertyManager.getProperty( "cryptography.properties" );
			MessageCryptography.init( propCrypto );
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}

		MessageTester tester = new MessageTester();
		tester.setSize( 700, 600 );
		tester.setVisible( true );
	}



    public MessageTester()
    {
        try
        {
            jbInit();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception
    {
        this.setDefaultCloseOperation(EXIT_ON_CLOSE);
        this.setTitle("Message Tester");
        this.addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                this_windowClosing(e);
            }
        });
        this.getContentPane().add(panelMain, BorderLayout.CENTER);
    }

    void this_windowClosing(WindowEvent e)
    {
		System.exit( 0 );
    }
}