package fccsc.manager.data.edi;

import intarsys.util.StringTools;


public final class StandardDataBlock
	extends AbstractBlock
{
	public static final int SIZE = 676;


    public
	StandardDataBlock( String p_data )
    {
		super( p_data.substring( ControlBlock.SIZE, ControlBlock.SIZE + SIZE ) );
    }


	public String getRequest()       { return StringTools.substring( data,  22,   1 ); }
	public String getProcess()       { return StringTools.substring( data,  46,  10 ); }
	public String getStateKey()      { return StringTools.substring( data,  79,  16 ); }
	public String getIpAddress()     { return StringTools.substring( data, 118,  15 ); }
	public String getIpPort()        { return StringTools.substring( data, 156,   5 ); }
	public String getReturnData()    { return StringTools.substring( data, 184,  50 ); }
	public String getHTMLKey()       { return StringTools.substring( data, 257,  30 ); }
	public String getStudentID()     { return StringTools.substring( data, 310,  12 ); }
	public String getPinPassword()   { return StringTools.substring( data, 345,  15 ); }
	public String getWait()          { return StringTools.substring( data, 383,   1 ); }
	public String getReturnCode()    { return StringTools.substring( data, 407,   5 ); }
	public String getReturnMessage() { return StringTools.substring( data, 435, 240 ); }


	// PBSC palermor IR174860 START
	public void
	setRequest( String p_request )
	{
		this.data.replace( 22, 22 + 1, p_request );
	}
	// PBSC palermor IR174860 END

	public void
	setReturnCode( String p_code )
	{
		String code = StringTools.padRight( p_code, 5, ' ' );

		this.data.replace( 407, 407 + 5, code );
	}


	public void
	setReturnMessage( String p_message )
	{
		String msg = StringTools.padRight( p_message, 240, ' ' );

		this.data.replace( 435, 435 + 240, msg );
	}


	public String
	toString()
	{
		StringBuffer buffer = new StringBuffer();

		buffer.append( "\nStandard-Data Block" );
		buffer.append( "\n   Request       [" + getRequest()       + "]" );
		buffer.append( "\n   Process       [" + getProcess()       + "]" );
		buffer.append( "\n   StateKey      [" + getStateKey()      + "]" );
		buffer.append( "\n   IpAddress     [" + getIpAddress()     + "]" );
		buffer.append( "\n   IpPort        [" + getIpPort()        + "]" );
		buffer.append( "\n   ReturnData    [" + getReturnData()    + "]" );
		buffer.append( "\n   HTMLKey       [" + getHTMLKey()       + "]" );
		buffer.append( "\n   StudentID     [" + getStudentID()     + "]" );
		buffer.append( "\n   PinPassword   [" + getPinPassword()   + "]" );
		buffer.append( "\n   Wait          [" + getWait()          + "]" );
		buffer.append( "\n   ReturnCode    [" + getReturnCode()    + "]" );
		buffer.append( "\n   ReturnMessage [" + getReturnMessage() + "]" );
		buffer.append( "\n" );

		return buffer.toString();
	}
}