package fccsc.manager.data.process;

/**
 * History
 * *******
 * 04/20/2017	Ian Peterson	Log 23809: Increase student password from 6 chars to 15 chars.
 */

import intarsys.util.StringTools;
import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.edi.CourseListBlock;
import fccsc.manager.data.edi.StandardDataBlock;


public final class CourseList
	extends ProcessFEDI
{
    public
	CourseList()
    {
		super( "message.COURSELIST.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		// setup our return codes
		String resRC      = ReturnCodes.CODE_00000;
		String resMessage = ReturnCodes.CODE_00000_MESSAGE;
		String clData     = "";


		String studId  = this.getEDIStandardDataBlock().getStudentID();
		String studPwd = this.getEDIStandardDataBlock().getPinPassword();

		studId  = StringTools.padRight( studId,  9,  ' ' );
		studPwd = StringTools.padRight( studPwd, 15, ' ' );			// Log 23809

		String data = studId + studPwd;

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response      = broker.getResponse();
		//String resParams     = (String) response.substring(   0,   0 + 15    );
		//String resExpand     = (String) response.substring(  15,  15 + 85    );
		String resCourseList = response.substring( 100, 100 + 25900 );
		//System.out.println( "CourseList [" + resCourseList + "]" );


		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( resCourseList.trim().length() == 0 )
		{
			resRC      = ReturnCodes.CODE_00048;
	    	resMessage = ReturnCodes.CODE_00048_MESSAGE;
			clData     = "";

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}
		else
		{
			CourseListBlock ediCLB = new CourseListBlock( studId, resCourseList );
	    	ediCLB.buildResponse();
			clData = ediCLB.getData();
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC );
		this.getEDIStandardDataBlock().setReturnMessage( resMessage );


		//////////////////////////////////////////////////////////////
		// build response and store
		//
		StringBuffer buffer = new StringBuffer();

		String dataPDB = this.getRequest().substring( ControlBlock.SIZE + StandardDataBlock.SIZE );

		//int lenTRS   = Integer.parseInt( (String) this.getEDIControlBlock().getTotalRecordSize() );
		int lenPDB   = dataPDB.length();
		int lenCL    = clData.length();
		int lenTotal = ControlBlock.SIZE + StandardDataBlock.SIZE + lenPDB + lenCL;

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		buffer.append( this.getEDIControlBlock().getData() );
		buffer.append( this.getEDIStandardDataBlock().getData() );
		buffer.append( dataPDB );
		buffer.append( clData );

		this.setResponse( buffer.toString() );
	}
}