package fccsc.manager.data.process;

import intarsys.util.StringTools;
import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.edi.CourseListBlock;
import fccsc.manager.data.edi.FACTSShopBlock;
import fccsc.manager.data.edi.StandardDataBlock;
import fccsc.manager.util.TemplateManager;


public final class FactsShop
	extends ProcessFEDI
{
	private StringBuffer data = new StringBuffer();

	/**
	 * Creates an object to process a FACTSSHOP message.
	 */
    public
	FactsShop()
    {
		super( "message.FACTSSHOP.properties" );
    }



	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		// setup the return code and message
		String resRC      = ReturnCodes.CODE_00000;
		String resMessage = ReturnCodes.CODE_00000_MESSAGE;

		// get the student id
		String studId = this.getEDIStandardDataBlock().getStudentID(); // 9 bytes

		// get the data trailing after ... CB + SDB + PDB ... this should be the course list block.
		String extra  = this.getRequest().substring(      ControlBlock.SIZE +
					 								 StandardDataBlock.SIZE +
													    FACTSShopBlock.SIZE );

		FACTSShopBlock  ediFSB = new FACTSShopBlock( this.getRequest() );
		CourseListBlock ediCLB = new CourseListBlock( studId, extra );
		ediCLB.buildRequest();

		       studId      = StringTools.padRight( studId,  9, ' ' );             //    9 bytes
		String program     = StringTools.padRight( ediFSB.getMajor(), 5, ' ' );   //    5 bytes
		String term        = "19991 ";                                            //    6 bytes
		String currentTerm = "19991 ";                                            //    6 bytes
		String demoGrafix  = parameterDemoGrafix( ediCLB );                       //   71 bytes
		String courseList  = parameterCourseList( ediCLB );                       // 2800 bytes

		if ( program.trim().length() == 0 )
		{
			resRC      = ReturnCodes.CODE_00012;
			resMessage = ReturnCodes.CODE_00012_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}
		else
		{
			String request = studId + program + term + currentTerm + demoGrafix + courseList;

			EntireXBroker broker = new EntireXBroker( this.getProperties() );
			broker.sendMessage( request );

			// get response message
			String response = broker.getResponse(); // fetch all of the data

			if ( logger.isDebugEnabled() )
	    	{
		    	logger.debug( "Broker Response [" + response + "]" );
		    }

			if ( response.trim().length() == 0 )
			{
				resRC      = ReturnCodes.CODE_00048;
				resMessage = ReturnCodes.CODE_00048_MESSAGE;

				logger.error( "Error [" + resRC + " - " + resMessage + "]" );
			}
			else
			{
				processData( response );
			}
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC );
		this.getEDIStandardDataBlock().setReturnMessage( resMessage );


		//////////////////////////////////////////////////////////////
		// build response and store
		//
		StringBuffer buffer = new StringBuffer();

		int lenCB    = ControlBlock.SIZE;
		int lenSDB   = this.getEDIStandardDataBlock().getData().length();
		int lenPDB   = this.data.length();
		int lenTotal = lenCB + lenSDB + lenPDB;

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		buffer.append( this.getEDIControlBlock().getData() );
		buffer.append( this.getEDIStandardDataBlock().getData() );
		buffer.append( this.data.toString() );

		this.setResponse( buffer.toString() );
	}


	private void
	processData( String p_data )
	{
		////////////////////////////////////////////////////////////////
		// data parsing
		//
		StringBuffer buffer = new StringBuffer();
		String       html   = "";
		String       line   = "";   // 79 bytes
		int          MAX    = 79;   // max # bytes a line can have
		int          len    = p_data.length();

		for ( int i = 0; i < len; /**/ )
		{
			if ( (i + MAX) <= len )
			{
			    line = p_data.substring( i, i + MAX );
				i = i + MAX;
			}
			else
			{
			    line = p_data.substring( i );
				i = len;
			}

		    if ( line.trim().length() > 0 )
			{
				// adds this ... <HR> before this ...
				//                   *** Program of Study Course Requirements ***
				//
				if ( line.indexOf( "   *** " ) > -1 )
				{
					buffer.append( "<hr>\n" );
				}
				// adds this ... <HR Align=Center Width=65%> before this ...
				//     Area 01:(07A) GENERAL EDUCATION              Min.Hours:18.00 Min.Crses: 6
				//
				else if ( (line.indexOf( "   Area " ) > -1) && (line.indexOf( "Min.Crses" ) > -1) )
				{
					buffer.append( "<hr align='center' width='65%'>\n" );
				}

				// trim off trailing spaces
				line = StringTools.trimTrailingWhitespace( line );

			    buffer.append( line + "\n" );  // line + carriage return + linefeed character
				//System.out.println( "line a [" + line + "]" );
			}
		}

		////////////////////////////////////////////////////////////////
		// populate a template
		html = TemplateManager.populate( "FACTSSHOP.template", buffer.toString() );

		////////////////////////////////////////////////////////////////
		// build "Process Data Block" section
		//
		String lenHtml = String.valueOf( html.length() );

		this.data.append( StringTools.padRight(      "", 8, ' ' ) );  //  8 filler
		this.data.append( StringTools.padLeft(  lenHtml, 6, '0' ) );  //  6 html data length
		this.data.append( "AUDITDAT" );
		this.data.append( html );                                     //  ? html data
		this.data.append( "\n" );                                     //  1 linefeed character
	}


	/**
	 * Builds the parameter data for DemoGrafix from the CLB.
	 * This is used to send as parameter data to broker
	 * @param p_ediCLB the course list block data.
	 * @return the demografx edi structure.
	 */
	protected String
	parameterDemoGrafix( CourseListBlock p_ediCLB )
	{
		// return Name + DOB ... a total of 71 bytes
		//
		return StringTools.padRight(
						    StringTools.padRight( p_ediCLB.getStudentName(), 60, ' ' ) +
						    StringTools.padRight( p_ediCLB.getStudentDOB(),   8, ' ' ),
							71, ' ' );
	}


	/**
	 * Builds the parameter data for CourseList from the CLB.
	 * This is used to send as parameter data to broker
	 * @param p_ediCLB the course list block data.
	 * @return the courselist edi structure.
	 */
	protected String
	parameterCourseList( CourseListBlock p_ediCLB )
	{
		return StringTools.padRight( p_ediCLB.getData(), 2800, ' ' );
	}
}
