package fccsc.manager.data.process;

import fccsc.manager.data.edi.StandardDataBlock;


public abstract class ProcessFEDI
	extends Process
{
	private StandardDataBlock ediSDB = null;


    public
	ProcessFEDI( String p_propertiesFileName )
    {
		super( p_propertiesFileName );
    }

	/**
	 * Returns the EDI Standard Data Block parsed from the data.
	 * @return edi standard data block.
	 */
	public StandardDataBlock getEDIStandardDataBlock() { return this.ediSDB; }


	/**
	 * Sets the incoming data to process.
	 * @param p_data the data to be processed.
	 * @throws Exception
	 */
	public void
	setRequest( String p_data ) throws Exception
	{
		super.setRequest( p_data );

		this.ediSDB = new StandardDataBlock( super.getRequest() );

		this.setCallBackIpAddress( this.ediSDB.getIpAddress() );
		this.setCallBackIpPort( Integer.parseInt( this.ediSDB.getIpPort() ) );
	}
}