package fccsc.manager.data.process;

import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.xml.FactsMessage;


public final class ProcessUnknownFXML
	extends ProcessFXML
{

    public
	ProcessUnknownFXML()
    {
		super( "" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		//////////////////////////////////////////////////////////////
		// build response and store
		//
		FactsMessage factsMessage = new FactsMessage( this.getRequest() );
	    factsMessage.setReturnCode(    ReturnCodes.CODE_00300         );
		factsMessage.setReturnMessage( ReturnCodes.CODE_00300_MESSAGE );

		String xml      = factsMessage.getXML();
		int    lenTotal = ControlBlock.SIZE + xml.length();

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		this.setResponse( this.getEDIControlBlock().getData() + xml );
	}
}
