package fccsc.manager.data.process;

/**
 * PBSC History
 * ************
 * PBSC palermor IR158889 01/07/2015 Escape HTML.
 *  
 * 04/20/2017	Ian Peterson	Log 23809: Increase student password from 6 chars to 15 chars.
 */

import intarsys.util.StringTools;

import org.apache.commons.lang3.StringEscapeUtils;

import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.util.TemplateManager;


public final class Transcript
	extends ProcessFEDI
{
	private StringBuffer data = new StringBuffer();


	/**
	 * Creates an object to process TRANSCRIPT messages.
	 */
    public
	Transcript()
    {
		super( "message.TRANSCRIPT.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		// setup our return codes
		String resRC      = ReturnCodes.CODE_00000;
		String resMessage = ReturnCodes.CODE_00000_MESSAGE;

		String studId  = this.getEDIStandardDataBlock().getStudentID();
		String studPwd = this.getEDIStandardDataBlock().getPinPassword();

		studId  = StringTools.padRight( studId,  9,  ' ' );
		studPwd = StringTools.padRight( studPwd, 15, ' ' );			// Log 23809

		String data = studId + studPwd;

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response     =  broker.getResponse();
		//String resParams     = (String) response.substring(   0,   0 + 15    );
		//String resExpand     = (String) response.substring(  15,  15 + 85    );
		String resTranscript = response.substring( 100, 100 + 25900 );

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( resTranscript.trim().length() == 0 )
		{
			resRC      = ReturnCodes.CODE_00048;
			resMessage = ReturnCodes.CODE_00048_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}
		else
		{
			processData( resTranscript );
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC );
		this.getEDIStandardDataBlock().setReturnMessage( resMessage );


		//////////////////////////////////////////////////////////////
		// build response and store
		//
		StringBuffer buffer = new StringBuffer();

		int lenTRS   = Integer.parseInt( this.getEDIControlBlock().getTotalRecordSize() );
		int lenPDB   = this.data.length();
		int lenTotal = lenTRS + lenPDB;

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		buffer.append( this.getEDIControlBlock().getData() );
		buffer.append( this.getEDIStandardDataBlock().getData() );
		buffer.append( this.data.toString() );

		this.setResponse( buffer.toString() );
	}


	private void
	processData( String p_data )
	{
		////////////////////////////////////////////////////////////////
		// data parsing
		//
		StringBuffer buffer = new StringBuffer();
		String       html   = "";
		String       line   = "";   // 78 bytes
		int          MAX    = 78;   // max # bytes a line can have
		int          len    = p_data.length();

		for ( int i = 0; i < len; /**/ )
		{
			if ( (i + MAX) <= len )
			{
			    line = p_data.substring( i, i + MAX );
				i = i + MAX;
			}
			else
			{
			    line = p_data.substring( i );
				i = len;
			}

		    if ( line.trim().length() > 0 )
			{
		    	line = StringEscapeUtils.escapeHtml4(line);  // PBSC palermor IR158889
			    buffer.append( line + "\n" );  // line + linefeed character
			}
		}

		////////////////////////////////////////////////////////////////
		// populate a template
		html = TemplateManager.populate( "TRANSCRIPT.template", buffer.toString() );

		////////////////////////////////////////////////////////////////
		// build "Process Data Block" section
		//
		String lenHtml = String.valueOf( html.length() );

		this.data.append( StringTools.padRight(      "", 8, ' ' ) );  //  8 filler
		this.data.append( StringTools.padLeft(  lenHtml, 6, '0' ) );  //  6 html data length
		this.data.append( "TRANDATA" );
		this.data.append( html );                                     //  ? html data
		this.data.append( "\n" );                                     //  1 linefeed character
	}
}