package fccsc.manager.data.process;

/**
 * History
 * *******
 * 04/20/2017	Ian Peterson	Log 23809: Increase student password from 6 chars to 15 chars.
 */

import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import intarsys.util.StringTools;


public final class Verify
	extends ProcessFEDI
{
	/**
	 * Creates an object to process VERIFY messages.
	 */
    public
	Verify()
    {
		super( "message.VERIFY.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		String studId  = this.getEDIStandardDataBlock().getStudentID();
		String studPwd = this.getEDIStandardDataBlock().getPinPassword();
		String term    = "";

		studId  = StringTools.padRight( studId,  9,  ' ' );
		studPwd = StringTools.padRight( studPwd, 15, ' ' );			// Log 23809
		term    = StringTools.padRight(      "", 6,  ' ' );

		String data = studId + studPwd + term;

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response     = broker.getResponse();
		String resRC        = response.substring( 96,   96 + 4   );
		String resDemoGrafx = response.substring( 100, 100 + 240 );

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( resRC.equalsIgnoreCase( "0000" ) )
		{
		    resRC = ReturnCodes.CODE_00000;
		}

		if ( resDemoGrafx.trim().length() == 0 )
		{
		    resRC        = ReturnCodes.CODE_00048;
			resDemoGrafx = ReturnCodes.CODE_00048_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resDemoGrafx + "]" );
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC );
		this.getEDIStandardDataBlock().setReturnMessage( resDemoGrafx );


		this.setResponse( this.getEDIControlBlock().getData() +
								this.getEDIStandardDataBlock().getData() );
	}
}