package fccsc.manager.data.xml;

import intarsys.xml.handler.XMLHandler;

import org.xml.sax.AttributeList;


/**
 * This is an object used to process an Error message with
 * the following XML structure:
 *
 * <?xml version='1.0' encoding='UTF-8' ?>
 * <!DOCTYPE Error [
 * <!ELEMENT Error (Sender,Receiver)>
 * 	<!ELEMENT Sender (#PCDATA)>
 * 	<!ELEMENT Receiver (Status)>
 * 		<!ELEMENT Status (#PCDATA)>]>
 * <Error>
 * 	<Sender></Sender>
 * 	<Receiver>
 * 		<Status> ... </Status>
 * 	</Receiver>
 * </Error>
 *
 *
 * @author Tony Blanco
 * @version 1.0
 */
@SuppressWarnings("deprecation")
public final class ErrorHandler
	extends XMLHandler
{
	private String  value  = "";
	private String  status = "";
	private boolean bErrorMessage = false;


	public
	ErrorHandler()
	{
	}


	public String getStatus() { return this.status; }


	public boolean isErrorMessage() { return this.bErrorMessage; }


	/**
	 * This is a handler method that is automatically called by the SAX parser.
	 * This method parses the starting of XML tags.
	 * This method would never be used explicitly by a programmer.
	 *
	 * @exclude
	 */
	public void
	startElement (String name, AttributeList attr)
	{
	}


	/**
	 * This is a handler method that is automatically called by the SAX parser.
	 * This method parses the ending of XML tags.
	 * This method would never be used explicitly by a programmer.
	 *
	 * @exclude
	 */
	public void
	endElement (String name)
	{
		this.value = getElementValue();

		if ( name.equalsIgnoreCase( "Status" ) )
		{
			this.status = value;
		}
		else if ( name.equalsIgnoreCase( "Error" ) )
		{
			this.bErrorMessage = true;
		}

		super.clearElementValue();
	}
}
