package fccsc.manager.data.xml;

/**
 * PBSC History
 * ************
 * PBSC palermor IR84565 05/19/2015 Update to log4j2.
 * PBSC palermor IR84565 06/03/2015 Fix a few single quotes and always return as UTF-8.
 * PBSC palermor IR84565 07/14/2015 Wrap RETNMESS value as CDATA.
 */

import intarsys.xml.SAXManager;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import fccsc.manager.data.edi.AbstractBlock;
import fccsc.manager.data.edi.ControlBlock;


public final class FactsMessage
	extends AbstractBlock
{
    private Logger logger = LogManager.getLogger( FactsMessage.class );  // PBSC palermor IR84565

	protected String Process       = "";
	protected String Request       = "";
	protected String Wait          = "";
	protected String StateKey      = "";
	protected String IpAddress     = "";
	protected String IpPort        = "";
	protected String ReturnData    = "";
	protected String HTMLKey       = "";
	protected String StudentID     = "";
	protected String PinPassword   = "";
	protected String ReturnCode    = "";
	protected String ReturnMessage = "";

	private   String RequestData   = "";

	private ControlBlock ediCB = null;


//	public static void
//	main( String [] args )
//	{
//		String data =   "000566TCP FXML00FLACENTSERV0008887000001010                 " +
//						"<?xml version='1.0'?><FACTS_MESSAGE Process='22ADVISE  ' Request='Y' Wait='N'><STANDARD_BLK><STATEKEY>T0001274M0000006</STATEKEY>" +
//					    "<IPADDRESS>10.0.0.4       </IPADDRESS><PORT>05200</PORT><RETNDATA>WA00,                           SWWP0F00P0001282  </RETNDATA>" +
//					    "<HTMLKEY>;2C;;2001;</HTMLKEY><STUID>000000006   </STUID><PIN_PW>0969           </PIN_PW><RETNCODE>00000</RETNCODE>" +
//					    "<RETNMESS></RETNMESS></STANDARD_BLK><ADVISE22_REQ><MAJOR>10504</MAJOR><CATLYEAR>2001</CATLYEAR></ADVISE22_REQ></FACTS_MESSAGE>";
//
//		FactsMessage fm = new FactsMessage( data );
//
//		System.out.println( "fm [" + fm.toString() + "]" );
//
//		fm.setReturnCode( "12546" );
//		fm.setReturnMessage( "BLAH BLAH BLAH :)" );
//
//		System.out.println( "fm  [" + fm.toString() + "]" );
//		System.out.println( "xml [" + fm.getXML()   + "]" );
//	}




    public
	FactsMessage( String p_data )
    {
		// FACTS_MESSAGE
		super( p_data.substring(   p_data.lastIndexOf( "<?xml"  ),
											p_data.lastIndexOf( "</FACTS_MESSAGE>" ) + 16 ) );

		this.ediCB = new ControlBlock( p_data );

		int posStart = -1;
		int posEnd   = -1;

		try
		{
			new SAXManager().parseSAXString( new FactsMessageHandler( this ), this.data.toString() );

			if ( this.getProcess().trim().equalsIgnoreCase( "ADMISSION" ) )
			{
				posStart = this.data.lastIndexOf( "<ADMISSION_REQ"   );
				posEnd   = this.data.lastIndexOf( "</FACTS_MESSAGE>" );

				if ( (posStart >= 0) && (posEnd >= 0) )
				{
					this.RequestData = this.data.substring( posStart , posEnd );
				}
			}
			else if ( this.getProcess().trim().equalsIgnoreCase( "22ADVISE" ) )
			{
				posStart = this.data.lastIndexOf( "<ADVISE22_REQ"  );
				posEnd   = this.data.lastIndexOf( "</FACTS_MESSAGE>" );

				if ( (posStart >= 0) && (posEnd >= 0) )
				{
				    this.RequestData = this.data.substring( posStart , posEnd );
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			logger.error( ex.getMessage() );
		}
    }


	public String getRequest()       { return this.Request;       }
	public String getProcess()       { return this.Process;       }
	public String getStateKey()      { return this.StateKey;      }
	public String getIpAddress()     { return this.IpAddress;     }
	public String getIpPort()        { return this.IpPort;        }
	public String getReturnData()    { return this.ReturnData;    }
	public String getHTMLKey()       { return this.HTMLKey;       }
	public String getStudentID()     { return this.StudentID;     }
	public String getPinPassword()   { return this.PinPassword;   }
	public String getWait()          { return this.Wait;          }
	public String getReturnCode()    { return this.ReturnCode;    }
	public String getReturnMessage() { return this.ReturnMessage; }
	public String getRequestData()   { return this.RequestData;   }


	public ControlBlock getEDIControlBlock() { return this.ediCB; }
	
	// PLOG 23579
	public void
    setRequest( String req ) { this.Request = req; }



	public void
	setReturnCode( String p_code ) { this.ReturnCode = p_code; }


	public void
	setReturnMessage( String p_message ) { this.ReturnMessage = p_message; }


	public void
	setRequestData( String p_data ) { this.RequestData = p_data; }


	public String
	getXML()
	{
		StringBuffer buffer = new StringBuffer();

		// PBSC palermor IR84565
		buffer.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
		buffer.append(  "<FACTS_MESSAGE   Process=\"" + this.Process + "\"" );
		buffer.append(                  " Request=\"" + this.Request + "\""  );
		buffer.append(                  " Wait=\""    + this.Wait    + "\">" );
		buffer.append(      "<STANDARD_BLK>" );
		buffer.append(          "<STATEKEY>"  + this.StateKey      + "</STATEKEY>" );
		buffer.append(          "<IPADDRESS>" + this.IpAddress     + "</IPADDRESS>" );
		buffer.append(          "<PORT>"      + this.IpPort        + "</PORT>" );
		buffer.append(          "<RETNDATA>"  + this.ReturnData    + "</RETNDATA>" );
		buffer.append(          "<HTMLKEY>"   + this.HTMLKey       + "</HTMLKEY>" );
		buffer.append(          "<STUID>"     + this.StudentID     + "</STUID>" );
		buffer.append(          "<PIN_PW>"    + this.PinPassword   + "</PIN_PW>" );
		buffer.append(          "<RETNCODE>"  + this.ReturnCode    + "</RETNCODE>" );
		buffer.append(          "<RETNMESS><![CDATA["  + this.ReturnMessage + "]]></RETNMESS>" );  // PBSC palermor IR84565
		buffer.append(      "</STANDARD_BLK>" );
		buffer.append(      this.getRequestData() );
		buffer.append( "</FACTS_MESSAGE>" );

		return buffer.toString();
	}


	public String
	toString()
	{
		StringBuffer buffer = new StringBuffer();

		buffer.append( "\nFacts Message" );
		buffer.append( "\n   Request       [" + getRequest()       + "]" );
		buffer.append( "\n   Process       [" + getProcess()       + "]" );
		buffer.append( "\n   StateKey      [" + getStateKey()      + "]" );
		buffer.append( "\n   IpAddress     [" + getIpAddress()     + "]" );
		buffer.append( "\n   IpPort        [" + getIpPort()        + "]" );
		buffer.append( "\n   ReturnData    [" + getReturnData()    + "]" );
		buffer.append( "\n   HTMLKey       [" + getHTMLKey()       + "]" );
		buffer.append( "\n   StudentID     [" + getStudentID()     + "]" );
		buffer.append( "\n   PinPassword   [" + getPinPassword()   + "]" );
		buffer.append( "\n   Wait          [" + getWait()          + "]" );
		buffer.append( "\n   ReturnCode    [" + getReturnCode()    + "]" );
		buffer.append( "\n   ReturnMessage [" + getReturnMessage() + "]" );
		buffer.append( "\n   RequestData   [" + getRequestData()   + "]" );
		buffer.append( "\n" );

		return buffer.toString();
	}
}