package fccsc.manager.data.xml;

import intarsys.xml.handler.XMLHandler;

import org.xml.sax.AttributeList;


@SuppressWarnings("deprecation")
public class FactsMessageHandler
	extends XMLHandler
{
	private String       value = "";
	private FactsMessage fm    = null;

	private boolean inStandardBlock = false;


    public
	FactsMessageHandler( FactsMessage p_fm )
    {
		this.fm = p_fm;
    }


	public void
	startElement( String name, AttributeList atts )
	{
		if ( name.equalsIgnoreCase( "FACTS_MESSAGE" ) )
		{
			fm.Process = super.getAttribute( atts, "Process" );
			fm.Request = super.getAttribute( atts, "Request" );
			fm.Wait    = super.getAttribute( atts, "Wait"    );
		}
		else if ( name.equalsIgnoreCase( "STANDARD_BLK" ) )
		{
			this.inStandardBlock = true;
		}
	}


	public void
	endElement( String name )
	{
		value = super.getElementValue();

		if ( inStandardBlock )
		{
			processStandardBlock( name, value );
		}

		if ( name.equalsIgnoreCase( "STANDARD_BLK" ) )
		{
			inStandardBlock = false;
		}

		super.clearElementValue();
	}



	private void
	processStandardBlock( String name, String value )
	{
		if (      name.equalsIgnoreCase( "STATEKEY" ) )   { fm.StateKey  = value; }
		else if ( name.equalsIgnoreCase( "IPADDRESS" ) )  { fm.IpAddress = value; }
		else if ( name.equalsIgnoreCase( "PORT" ) )       { fm.IpPort      = value; }
		else if ( name.equalsIgnoreCase( "RETNDATA" ) )   { fm.ReturnData  = value; }
		else if ( name.equalsIgnoreCase( "HTMLKEY" ) )    { fm.HTMLKey   = value; }
		else if ( name.equalsIgnoreCase( "STUID" ) )      { fm.StudentID     = value; }
		else if ( name.equalsIgnoreCase( "PIN_PW" ) )     { fm.PinPassword    = value; }
		else if ( name.equalsIgnoreCase( "RETNCODE" ) )   { fm.ReturnCode  = value; }
		else if ( name.equalsIgnoreCase( "RETNMESS" ) )   { fm.ReturnMessage  = value; }
	}
}