/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SignException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Identity {
    private String name;
    private String keyAlias;
    private String serialNumber;
    private X509Certificate x509Cert;
    private PrivateKey privateKey;
    private MerchantConfig merchantConfig;
    private static final String SERVER_ALIAS = "CyberSource_SJC_US";

    public Identity(MerchantConfig merchantConfig, X509Certificate x509Certificate) throws SignException {
        this.merchantConfig = merchantConfig;
        this.x509Cert = x509Certificate;
        if (merchantConfig.isJdkCertEnabled()) {
            this.setupJdkServerCerts();
        } else {
            this.setUpServer();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupJdkServerCerts() throws SignException {
        if (this.x509Cert == null) return;
        String subjectDN = this.x509Cert.getSubjectDN().getName();
        if (subjectDN == null) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
        String[] subjectDNrray = subjectDN.split("SERIALNUMBER=");
        if (subjectDNrray.length == 1 && subjectDNrray[0].contains("CyberSourceCertAuth")) {
            this.keyAlias = "CyberSourceCertAuth";
            this.name = "CyberSourceCertAuth";
            return;
        } else {
            if (subjectDNrray.length != 2 || !subjectDNrray[1].contains(SERVER_ALIAS)) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            this.name = SERVER_ALIAS;
            this.serialNumber = subjectDNrray[1];
            this.keyAlias = "serialNumber=" + this.serialNumber + ",CN=" + this.name;
        }
    }

    public Identity(MerchantConfig merchantConfig, X509Certificate x509Certificate, PrivateKey privateKey) throws SignException {
        this.merchantConfig = merchantConfig;
        this.x509Cert = x509Certificate;
        this.privateKey = privateKey;
        this.setUpMerchant();
    }

    private void setUpMerchant() throws SignException {
        if (this.serialNumber == null && this.x509Cert != null) {
            String subjectDN = this.x509Cert.getSubjectDN().getName();
            if (subjectDN != null) {
                String[] subjectDNrray = subjectDN.split("SERIALNUMBER=");
                if (subjectDNrray.length != 2) {
                    throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
                }
                this.name = this.merchantConfig.getMerchantID();
                this.serialNumber = subjectDNrray[1];
                this.keyAlias = "serialNumber=" + this.serialNumber + ",CN=" + this.name;
            } else {
                throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUpServer() throws SignException {
        if (this.serialNumber != null || this.x509Cert == null) return;
        String subjectDN = this.x509Cert.getSubjectDN().getName();
        if (subjectDN == null) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
        String[] subjectDNrray = subjectDN.split("SERIALNUMBER=");
        if (subjectDNrray.length == 1 && subjectDNrray[0].contains("CyberSourceCertAuth")) {
            this.keyAlias = "CyberSourceCertAuth";
            this.name = "CyberSourceCertAuth";
            return;
        } else {
            if (subjectDNrray.length != 2 || !subjectDNrray[0].contains(SERVER_ALIAS)) throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + this.merchantConfig.getKeyAlias() + "'");
            this.name = SERVER_ALIAS;
            this.serialNumber = subjectDNrray[1];
            this.keyAlias = "serialNumber=" + this.serialNumber + ",CN=" + this.name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public X509Certificate getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(X509Certificate x509Cert) {
        this.x509Cert = x509Cert;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String toString() {
        int certLen = 0;
        Date date = null;
        String expireStr = null;
        if (this.x509Cert != null) {
            try {
                certLen = this.x509Cert.getEncoded().length;
            }
            catch (CertificateEncodingException e) {
                certLen = 0;
            }
            date = this.x509Cert.getNotAfter();
        }
        this.serialNumber = this.getSerialNumber();
        int privateKeyLen = this.privateKey != null ? this.privateKey.getEncoded().length : 0;
        if (date != null) {
            TimeZone usPacificTimeZone = TimeZone.getTimeZone("America/Los_Angeles");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            formatter.setTimeZone(usPacificTimeZone);
            expireStr = formatter.format(date);
        }
        privateKeyLen = this.privateKey != null ? this.privateKey.getEncoded().length : 0;
        return "{" + this.getName() + ",privatekey=" + privateKeyLen + ",cert=" + certLen + ",serial=" + this.serialNumber + ",expiration=" + expireStr + " }";
    }
}

